/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.action.ShowHelpContextAction;
import DE.siemens.ad.logo.app.comp.ControlPanelEvent;
import DE.siemens.ad.logo.app.dialog.ControlPanel;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.Modem;
import DE.siemens.ad.logo.comm.SerialPortDataTransfer;
import DE.siemens.ad.logo.dialog.wizard.WizardDialog;
import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.modem.ModemWizardModel;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoAddressBook;
import DE.siemens.ad.logo.util.LogoModemSetting;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.action.ConnectModemToolAction;
import DE.siemens.ad.pdraw.action.DisconnectModemToolAction;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class ModemManager {
    public static volatile boolean fConnectionModem = false;
    private static volatile boolean fWizardFinished = false;
    private static WizardDialog wd;
    private static Hashtable atCommand;

    public static void activateDeactivateModemActions() {
        ConnectModemToolAction.getInstance().setActivated(!Modem.isModemConnected());
        DisconnectModemToolAction.getInstance().setActivated(Modem.isModemConnected());
    }

    public static void activeConnectModemActionState(boolean onlineTest) {
        if (!onlineTest && !Modem.isModemConnected()) {
            ConnectModemToolAction.getInstance().setActivated(true);
        } else {
            ConnectModemToolAction.getInstance().setActivated(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void connect() {
        fWizardFinished = false;
        if (!Modem.isModemConnected()) {
            String modemName = (String)LogoModemSetting.getInstance().getDefaultSettingName().get("DefaultLocal");
            atCommand = LogoModemSetting.getInstance().getAtSetting(true, modemName);
            Application application = Application.getInstance();
            wd = WizardDialog.createWizardDialog(application.getActiveApplicationSurface().getWindow(), true);
            ModemWizardModel updateModel = new ModemWizardModel();
            updateModel.setWizardDialog(wd);
            wd.setWizardModel(updateModel);
            wd.setFinishButtonText(Language.getString("wizard.modem.dial", "Dial"));
            ControlPanel controlPanel = new ControlPanel(8){

                public void helpPressed(ControlPanelEvent cpe) {
                    String helpID = null;
                    WizardInputPanel inputPanel = wd.getInputPanel();
                    if (inputPanel != null) {
                        helpID = inputPanel.getHelpIdString();
                    }
                    ShowHelpContextAction action = new ShowHelpContextAction();
                    action.setHelpID(helpID);
                    action.setActivationWindow((JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this));
                    action.doIt();
                }
            };
            wd.setControlPanel(controlPanel);
            wd.showWizardDialog();
        }
        if (fWizardFinished) {
            try {
                String portName = LogoProperties.instance().getProperty("port", "COM2");
                fConnectionModem = true;
                DataTransfer dt = SerialPortDataTransfer.openConnection(portName, true, true);
                Modem.getInstance().setDataTransfer(dt);
                if (!Modem.getInstance().connectModem(portName, ModemManager.getLocalAtCommandString(), true)) {
                    throw new ExceptionAlreadyHandledException();
                }
            }
            catch (ExceptionAlreadyHandledException e) {
                Modem.getInstance().setDataTransfer(null);
            }
            finally {
                fConnectionModem = false;
            }
        }
        ModemManager.activateDeactivateModemActions();
    }

    public static void disconnect() {
        Modem.getInstance().disconnectModem();
        ModemManager.activateDeactivateModemActions();
    }

    public static LogoAddressBook getAddressBook() {
        return LogoAddressBook.instance(ModemManager.getColumnKeys());
    }

    public static String[] getColumnNames() {
        String[] ret = new String[]{Language.getString("dialog.options.connectionTab.addressBook.name", "Name"), Language.getString("dialog.options.connectionTab.addressBook.Phone", "Phone number"), Language.getString("dialog.options.connectionTab.addressBook.description", "Description")};
        return ret;
    }

    public static String[] getColumnKeys() {
        String[] ret = new String[]{"Name", "Phone_number", "Description"};
        return ret;
    }

    public static int getColumnIndex(String columnKey) {
        for (int i = 0; i < ModemManager.getColumnKeys().length; ++i) {
            if (!columnKey.equalsIgnoreCase(ModemManager.getColumnKeys()[i])) continue;
            return i;
        }
        return -1;
    }

    public static void setWizardFinished(boolean newValue) {
        fWizardFinished = newValue;
    }

    private static String getLocalAtCommandString() {
        StringBuffer stringATCommand = new StringBuffer("AT");
        if (atCommand != null) {
            stringATCommand.append(atCommand.get("reset")).append(" ");
            Enumeration commandKey = atCommand.keys();
            while (commandKey.hasMoreElements()) {
                String name = (String)commandKey.nextElement();
                if (name.equals("reset") || atCommand.get(name).equals("")) continue;
                stringATCommand.append(atCommand.get(name)).append(" ");
            }
        }
        return stringATCommand.toString();
    }

    public static void setAtCommand(Hashtable command) {
        atCommand = command;
    }
}

